﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Diagnostics;
using FDK;

namespace StrokeStyleT
{
	/// <summary>
	/// <para>ドラムパッドとパッドラインの描画を行う。</para>
	/// <para>通常は静止状態のパッドを描画するが、tヒット() を呼び出すとヒットアニメーションを行う。</para>
	/// <para>パッドとラインの位置は、Config で指定されている中央位置から決定する。</para>
	/// </summary>
	class CAct演奏パッド : CActivity
	{
		public void tヒット( E演奏レーン eレーン )
		{
			// dic縦方向加速度[]≠0 でヒットアニメ開始

			switch( eレーン )
			{
				case E演奏レーン.LeftCymbal:
					this.dic縦方向加速度[ Eパッド.LeftCymbal ] = +2;
					break;

				case E演奏レーン.HiHat:
					this.dic縦方向加速度[ Eパッド.HiHatTop ] = +2;	// ハイハットの上下は常に一緒に動く
					this.dic縦方向加速度[ Eパッド.HiHatBottom ] = +2;
					break;

				case E演奏レーン.Snare:
					this.dic縦方向加速度[ Eパッド.Snare ] = +2;
					break;

				case E演奏レーン.Tom1:
					this.dic縦方向加速度[ Eパッド.Tom1 ] = +2;
					break;

				case E演奏レーン.Bass:
					this.dic縦方向加速度[ Eパッド.Bass ] = +2;
					break;

				case E演奏レーン.Tom2:
					this.dic縦方向加速度[ Eパッド.Tom2 ] = +2;
					break;

				case E演奏レーン.Tom3:
					this.dic縦方向加速度[ Eパッド.Tom3 ] = +2;
					break;

				case E演奏レーン.RightCymbal:
					this.dic縦方向加速度[ Eパッド.RightCymbal ] = +2;
					break;
			}
		}

		public override void On活性化()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してる )
				return;
			//-----------------
			#endregion

			// パッドの位置は、Theme で指定されている中央位置から決定する。

			#region [ ptパッド2D表示左上隅座標の初期化 ]
			//-----------------
			var szPadHalf = new Size( 60, 60 );			// 各パッド画像のサイズは 120x120。
			int FrameX = Theme.演奏.n画面左端からフレーム左までの距離px;
			int ScreenBottom = Theme.szウィンドウ.Height;

			this.dicパッド2D表示左上隅座標 = new Dictionary<Eパッド, Point>() {
				{ Eパッド.LeftCymbal, Point.Subtract( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.LeftCymbal ], szPadHalf ) },
				{ Eパッド.FootPedal, Point.Subtract( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.FootPedal ], szPadHalf ) },
				{ Eパッド.HiHatTop, Point.Subtract( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.HiHat ], szPadHalf ) },
				{ Eパッド.HiHatBottom, Point.Subtract( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.HiHat ], szPadHalf ) },
				{ Eパッド.Snare, Point.Subtract( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Snare ], szPadHalf ) },
				{ Eパッド.Tom1, Point.Subtract( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Tom1 ], szPadHalf ) },
				{ Eパッド.Bass, Point.Subtract( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Bass ], szPadHalf ) },
				{ Eパッド.Tom2, Point.Subtract( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Tom2 ], szPadHalf ) },
				{ Eパッド.Tom3, Point.Subtract( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Tom3 ], szPadHalf ) },
				{ Eパッド.RightCymbal, Point.Subtract( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.RightCymbal ], szPadHalf ) },
			};
			//-----------------
			#endregion


			// パッドラインも同様。

			#region [ ptパッドライン2D表示左上隅座標の初期化 ]
			//-----------------
			var szLineHalf = new Size( 1, 0 );		// パッドライン画像のサイズは 2×n。
			
			this.dicパッドライン2D表示左上隅座標 = new Dictionary<Eパッド, Point>() {
				{ Eパッド.LeftCymbal, new Point( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.LeftCymbal ].X - szLineHalf.Width, 0 ) },
				{ Eパッド.FootPedal, new Point( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.FootPedal ].X - szLineHalf.Width, 0 ) },
				{ Eパッド.HiHatTop, new Point( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.HiHat ].X - szLineHalf.Width, 0 ) },
				{ Eパッド.HiHatBottom, new Point( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.HiHat ].X - szLineHalf.Width, 0 ) },
				{ Eパッド.Snare, new Point( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Snare ].X - szLineHalf.Width, 0 ) },
				{ Eパッド.Tom1, new Point( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Tom1 ].X - szLineHalf.Width, 0 ) },
				{ Eパッド.Bass, new Point( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Bass ].X - szLineHalf.Width, 0 ) },
				{ Eパッド.Tom2, new Point( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Tom2 ].X - szLineHalf.Width, 0 ) },
				{ Eパッド.Tom3, new Point( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Tom3 ].X - szLineHalf.Width, 0 ) },
				{ Eパッド.RightCymbal, new Point( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.RightCymbal ].X - szLineHalf.Width, 0 ) },
			};
			//-----------------
			#endregion


			// その他の初期化。

			#region [ 縦方向差分 ]
			//-----------------
			this.dic縦方向差分 = new Dictionary<Eパッド, int>() {
				{ Eパッド.LeftCymbal, 0 },
				{ Eパッド.FootPedal, 0 },
				{ Eパッド.HiHatTop, 0 },
				{ Eパッド.HiHatBottom, 0 },
				{ Eパッド.Snare, 0 },
				{ Eパッド.Tom1, 0 },
				{ Eパッド.Bass, 0 },
				{ Eパッド.Tom2, 0 },
				{ Eパッド.Tom3, 0 },
				{ Eパッド.RightCymbal, 0 },
			};
			//-----------------
			#endregion
			#region [ 縦方向加速度 ]
			//-----------------
			this.dic縦方向加速度 = new Dictionary<Eパッド, int>() {
				{ Eパッド.LeftCymbal, 0 },
				{ Eパッド.FootPedal, 0 },
				{ Eパッド.HiHatTop, 0 },
				{ Eパッド.HiHatBottom, 0 },
				{ Eパッド.Snare, 0 },
				{ Eパッド.Tom1, 0 },
				{ Eパッド.Bass, 0 },
				{ Eパッド.Tom2, 0 },
				{ Eパッド.Tom3, 0 },
				{ Eパッド.RightCymbal, 0 },
			};
			//-----------------
			#endregion
			#region [ テクスチャ内パッド領域 ]
			//-----------------
			this.dicテクスチャ内パッド領域 = new Dictionary<Eパッド, Rectangle>() {
				{ Eパッド.LeftCymbal, new Rectangle( 0, 0, 120, 120 ) },
				{ Eパッド.FootPedal, new Rectangle( 0, 0, 0, 0 ) },
				{ Eパッド.HiHatTop, new Rectangle( 0, 120, 120, 120 ) },
				{ Eパッド.HiHatBottom, new Rectangle( 120, 120, 120, 120 ) },
				{ Eパッド.Snare, new Rectangle( 240, 120, 120, 120 ) },
				{ Eパッド.Tom1, new Rectangle( 0, 240, 120, 120 ) },
				{ Eパッド.Bass, new Rectangle( 240, 0, 120, 120 ) },
				{ Eパッド.Tom2, new Rectangle( 120, 240, 120, 120 ) },
				{ Eパッド.Tom3, new Rectangle( 240, 240, 120, 120 ) },
				{ Eパッド.RightCymbal, new Rectangle( 120, 0, 120, 120 ) },
			};
			//-----------------
			#endregion
			#region [ テクスチャ内パッドライン領域 ]
			//-----------------
			this.dicテクスチャ内パッドライン領域 = new Dictionary<Eパッド, Rectangle>() {
				{ Eパッド.LeftCymbal, new Rectangle( 360, 0, 3, 360 ) },
				{ Eパッド.FootPedal, new Rectangle( 363, 0, 3, 360 ) },
				{ Eパッド.HiHatTop, new Rectangle( 366, 0, 3, 360 ) },
				{ Eパッド.HiHatBottom, new Rectangle( 366, 0, 3, 360 ) },
				{ Eパッド.Snare, new Rectangle( 369, 0, 3, 360 ) },
				{ Eパッド.Tom1, new Rectangle( 372, 0, 3, 360 ) },
				{ Eパッド.Bass, new Rectangle( 375, 0, 3, 360 ) },
				{ Eパッド.Tom2, new Rectangle( 378, 0, 3, 360 ) },
				{ Eパッド.Tom3, new Rectangle( 381, 0, 3, 360 ) },
				{ Eパッド.RightCymbal, new Rectangle( 384, 0, 3, 360 ) },
			};
			//-----------------
			#endregion

			base.On活性化();
		}
		public override void Onリソースの作成( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			this.txパッド = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenPlay pads.png" ) );
			this.m一定間隔処理 = new C一定間隔処理();

			base.Onリソースの作成( hDevice );
		}
		public override void Onリソースの解放()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			Global.tDisposeする( ref this.txパッド );
			Global.tDisposeする( ref this.m一定間隔処理 );

			base.Onリソースの解放();
		}
		public override int On進行()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return 0;
			//-----------------
			#endregion

			#region [ パッドのヒットアニメ ]
			//-----------------
			const int nパッドの振幅px = 5;

			this.m一定間隔処理.t進行( 5, () => {

				foreach( var pad in this.listパッド描画順序 )
				{
					this.dic縦方向差分[ pad ] += this.dic縦方向加速度[ pad ];

					if( this.dic縦方向差分[ pad ] > nパッドの振幅px )
					{
						this.dic縦方向差分[ pad ] = nパッドの振幅px;
						this.dic縦方向加速度[ pad ] = -1;		// 反転、上に向かう。
					}
					else if( this.dic縦方向差分[ pad ] < 0 )
					{
						this.dic縦方向差分[ pad ] = 0;
						this.dic縦方向加速度[ pad ] = 0;		// アニメ終了。
					}
				}
			} );
			//-----------------
			#endregion

			#region [ 現在のフットペダル値の取得。]
			//-----------------
			foreach( var ie in Global.Input.listMIDI入力イベント )
			{
				if( ie.nKey == 255 )
					this.n現在のフットペダル値0to127 = ie.nVelocity;
			}
			//-----------------
			#endregion

			return (int) E進行結果.継続;
		}
		public override void On描画( IntPtr hDevice )
		{
			throw new InvalidOperationException( "別の On描画 メソッドを使用すること。" );
		}
		
		public enum E描画対象 { パッド, パッドライン }
		public void On描画( IntPtr hDevice, E描画対象 e描画対象 )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない || this.txパッド == null )
				return;
			//-----------------
			#endregion

			if( e描画対象 == E描画対象.パッドライン )
			{
				#region [ パッドラインを描画する。]
				//-----------------
				foreach( var pad in this.listパッド描画順序 )
				{
					var rc = this.dicテクスチャ内パッドライン領域[ pad ];

					for( int j = 0; j < Theme.szウィンドウ.Height; j += rc.Height )
					{
						this.txパッド.t2D描画(
							hDevice,
							this.dicパッドライン2D表示左上隅座標[ pad ].X,
							this.dicパッドライン2D表示左上隅座標[ pad ].Y + j,
							rc );
					}
				}
				//-----------------
				#endregion
			}
			if( e描画対象 == E描画対象.パッド )
			{
				#region [ パッドを描画する。]
				//-----------------
				foreach( var pad in this.listパッド描画順序 )
				{
					int nHiHatTop差分px = 0;

					#region [ HiHatTop の場合のみ、現在のペダルの踏み込みに合わせて nHiHatTop差分px を計算する。]
					//-----------------
					if( pad == Eパッド.HiHatTop )
					{
						int nPedal可動範囲 = Global.Input.KeyAssign.FootPedalMax - Global.Input.KeyAssign.FootPedalMin;
						int nPedal相対値 = this.n現在のフットペダル値0to127 - Global.Input.KeyAssign.FootPedalMin;
						double dbPedal割合 = Math.Min( (double) nPedal相対値 / nPedal可動範囲, 1.0 );		// 相対値:0→127 のとき 割合:0.0→1.0

						nHiHatTop差分px = (int) ( this.szHiHatTopFromBottom差分px.Height * ( 1.0 - dbPedal割合 ) );
					}
					//-----------------
					#endregion

					this.txパッド.t2D描画(
						hDevice,
						this.dicパッド2D表示左上隅座標[ pad ].X,
						this.dicパッド2D表示左上隅座標[ pad ].Y + this.dic縦方向差分[ pad ] + nHiHatTop差分px,
						this.dicテクスチャ内パッド領域[ pad ] );
				}
				//-----------------
				#endregion
			}
		}


		readonly Size szHiHatTopFromBottom差分px = new Size( 0, -10 );	// HH上はHH下より10px上に配置。
		CTexture txパッド;
		C一定間隔処理 m一定間隔処理 = null;
		Dictionary<Eパッド, int> dic縦方向差分;
		Dictionary<Eパッド, int> dic縦方向加速度;
		Dictionary<Eパッド, Rectangle> dicテクスチャ内パッド領域;
		Dictionary<Eパッド, Rectangle> dicテクスチャ内パッドライン領域;
		Dictionary<Eパッド, Point> dicパッド2D表示左上隅座標;
		Dictionary<Eパッド, Point> dicパッドライン2D表示左上隅座標;
		int n現在のフットペダル値0to127 = 0;

		List<Eパッド> listパッド描画順序 = new List<Eパッド>() {
			Eパッド.FootPedal,		// 表示が最下位置
			Eパッド.Bass,
			Eパッド.Tom3,
			Eパッド.Tom2,
			Eパッド.Tom1,
			Eパッド.Snare,
			Eパッド.HiHatBottom,
			Eパッド.HiHatTop,
			Eパッド.LeftCymbal,
			Eパッド.RightCymbal,			// 表示が最上位置
		};
	}
}
